<?php
// Exit if accessed directly
if( ! defined( 'ABSPATH' ) ) exit;

/**
 * The code that runs during plugin activation.
 */

if( !function_exists( 'wppb_in_ffc_check_break_points_on_activation' ) ){
	function wppb_in_ffc_check_break_points_on_activation( $addon ){
		if( $addon == 'form-fields-in-columns' ){
			$wppb_manage_fields = get_option( 'wppb_manage_fields', 'not_found' );
			$old_break_points   = get_option( 'wppb_ffc_break_points', 'not_found' );

			if( $old_break_points != 'not_found' ) {
				$break_points = array();

				foreach( $wppb_manage_fields as $field ) {

					if( array_key_exists( intval( $field['id'] ), $old_break_points ) ) {
						$break_points[intval( $field['id'] )] = $old_break_points[intval( $field['id'] )];
					}
				}

				update_option( 'wppb_ffc_break_points', $break_points );
			}
		}
	}
	add_action( 'wppb_add_ons_activate', 'wppb_in_ffc_check_break_points_on_activation', 10, 1);
}